// Copyright 2025 Greyscalegorilla, Inc. 

#pragma once

#include "CoreMinimal.h"
#include "UObject/NoExportTypes.h"
#include "GreyscalegorillaMessages.h"
#include "GreyscalegorillaModelLoader.generated.h"

DECLARE_DELEGATE_OneParam(FOnModelErrorDelegate, FGSGConnectError);
DECLARE_DELEGATE_OneParam(FOnModelSuccessDelegate, FGSGConnectSuccess);

/**
 *
 */
UCLASS()
class UGresyscalegorillaModelLoader : public UObject
{
	GENERATED_BODY()

public:
	UGresyscalegorillaModelLoader();

	static UAssetImportTask *CreateImportTask(FString SourcePath, FString DestinationPath, UFactory *ExtraFactory, UObject *ExtraOptions, bool &bOutSuccess, FString &OutInfoMessage);
	static UObject *ProcessImportTask(UAssetImportTask *ImportTask, bool &bOutSuccess, FString &OutInfoMessage);
	static UStaticMesh *ImportStaticMesh(FString SourcePath, FString DestinationPath, bool &bOutSuccess, FString &OutInfoMessage);
	static TMap<FString, FString> GetPathsModels(const FString &RootPath);
	static TSharedPtr<FJsonObject> LoadGSGAMetadata(FString PathGSGA);
	static FString GenerateIncrementalModelName(const FString &RequestedName);
	static FOnModelErrorDelegate OnModelError;
	static FOnModelSuccessDelegate OnModelSuccess;
};
